<?php 
require_once 'includes/auth.php';
checkRole(['superadmin', 'developer']); // Sudah mencakup pengecekan login

// Ambil data supervisor untuk dropdown
try {
    $stmt = $pdo->prepare("SELECT id, username, nama_lengkap FROM supervisor WHERE deleted_at IS NULL AND active = 'active' ORDER BY nama_lengkap ASC");
    $stmt->execute();
    $supervisors = $stmt->fetchAll();
} catch(PDOException $e) {
    error_log("Error fetching supervisors: " . $e->getMessage());
}

include 'includes/header.php'; 
include 'includes/sidebar.php';
?>

<title>Dashboard - Miracle-TECH Phone Call System</title>

<div class="content" id="content">
    <div class="container-fluid">
        <h1 class="h3 mb-4">Dashboard</h1>
        
        <?php if(isset($_SESSION['error'])): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?php 
                echo $_SESSION['error'];
                unset($_SESSION['error']);
                ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <div class="row mb-3">
            <div class="col-md-3">
                <select class="form-select" id="supervisorSelect">
                    <option value="">Choose Supervisor</option>
                    <?php foreach($supervisors as $supervisor): ?>
                    <option value="<?php echo $supervisor['id']; ?>">
                        <?php echo htmlspecialchars($supervisor['nama_lengkap']); ?> 
                        (<?php echo htmlspecialchars($supervisor['username']); ?>)
                    </option>
                    <?php endforeach; ?>
                </select>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h5>Download Report</h5>
                    </div>
                    <div class="card-body">
                        <form action="download_mkt_report.php" method="GET">
                            <div class="mb-3">
                                <label class="form-label">Status</label>
                                <select class="form-select form-select-sm" name="status" required>
                                    <option value="">Select Status</option>
                                    <option value="1">Followed Up</option>
                                    <option value="0">Pending</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Date Range</label>
                                <div class="row">
                                    <div class="col-md-6">
                                        <input type="date" class="form-control form-control-sm" 
                                               name="start_date" required 
                                               max="<?php echo date('Y-m-d'); ?>">
                                    </div>
                                    <div class="col-md-6">
                                        <input type="date" class="form-control form-control-sm" 
                                               name="end_date" required 
                                               max="<?php echo date('Y-m-d'); ?>">
                                    </div>
                                </div>
                            </div>
                            <button type="submit" class="btn btn-primary btn-sm">
                                <i class="fas fa-download me-1"></i> Download Report (.xlsx)
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?> 