<?php
require_once 'includes/config.php';

header('Content-Type: application/json');

try {
    $stmt = $pdo->prepare("SELECT pin_value FROM pin_settings WHERE id = 1");
    $stmt->execute();
    $encryptedPin = $stmt->fetchColumn();
    
    // Dekripsi PIN sebelum dikirim
    $pin = decryptPin($encryptedPin);
    
    echo json_encode(['pin' => $pin]);
} catch(PDOException $e) {
    error_log("Error fetching PIN: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(['error' => 'Internal server error']);
} 