<?php 
require_once 'includes/auth.php';
require_once 'includes/config.php';
checkRole(['superadmin', 'developer']); 

// Ambil data login logs kecuali role developer
try {
    $stmt = $pdo->prepare("SELECT * FROM login_logs WHERE role != 'developer' ORDER BY login_time DESC");
    $stmt->execute();
    $logs = $stmt->fetchAll();
} catch(PDOException $e) {
    error_log("Error fetching login logs: " . $e->getMessage());
}

include 'includes/header.php'; 
include 'includes/sidebar.php';
?>

<div class="content" id="content">
    <div class="container-fluid">
        <h1 class="h3 mb-4">Login Logs</h1>
        
        <div class="card">
            <div class="card-body">
                <pre class="mb-0" style="max-height: 500px; overflow-y: auto;">
<?php foreach($logs as $log): ?>
<?php echo date('Y-m-d H:i:s', strtotime($log['login_time'])) . " | " . 
           str_pad($log['username'], 15) . " | " . 
           str_pad($log['role'], 10) . " | " . 
           str_pad($log['ip_address'], 15) . " | " . 
           $log['user_agent'] . "\n"; ?>
<?php endforeach; ?>
                </pre>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>